#lang scheme/base
(provide (all-defined-out))

; just some stuff which is probably defined in standard schemish somewhere

(define (assoc-remove k l)
  (cond
    ((null? l) '())
    ((eq? (car (car l)) k)
     (assoc-remove k (cdr l)))
    (else
     (cons (car l) (assoc-remove k (cdr l))))))

(define (choose l)
  (list-ref l (random (length l))))

(define (list-contains k l)
  (cond 
    ((null? l) #f)
    ((eq? (car l) k) #t)
    (else (list-contains k (cdr l)))))

(define (string-split s c)
  (define (_ sl tl cl)
    (cond 
      ((null? sl) (if (null? cl) tl (append tl (list (list->string cl)))))
      ((eq? (car sl) c)
       (_ (cdr sl) (append tl (list (list->string cl))) '()))
      (else
       (_ (cdr sl) tl (append cl (list (car sl)))))))
  (_ (string->list s) '() '()))

(define (list-string-concat l t)
  (cond
    ((null? l) "")
    (else
     (string-append (car l) t (list-string-concat (cdr l) t)))))

; returns a list of items in a but not in b
(define (list-remainder a b)
  (cond 
    ((null? a) '())
    ((not (list-contains (car a) b)) (cons (car a) (list-remainder (cdr a) b)))
    (else (list-remainder (cdr a) b))))

(define (which-element k l n)
  (cond 
    ((null? l) #f)
    ((eq? (car l) k) n)
    (else (which-element k (cdr l) (+ n 1)))))